<?php
$brandPackage = getContent('brand_package.content',true);
$packages = App\Models\BrandPackage::where('status',1)->get();
?>

<section class="pricing-plan section-bg py-80">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="section-heading  text-center">
                    <span class="subtitle"><?php echo e(__($brandPackage->data_values->top_heading)); ?></span>
                    <h2 class="section-heading__title">
                        <?php echo e(__($brandPackage->data_values->heading)); ?>

                    </h2>
                    <p class="section-heading__desc"><?php echo e(__($brandPackage->data_values->sub_heading)); ?></p>
                </div>
            </div>
        </div>
        <div class="row gy-4 justify-content-center position-relative">
            <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-lg-4 col-md-6">
                <div class="pricing-plan-item">
                    <img class="price-shape-bg" src="<?php echo e(asset($activeTemplateTrue.'images/price-shape-bg.png')); ?>" alt="image">
                    <div class="price-shape-2"></div>
                    <div class="pricing-plan-item__top">
                        <h3 class="title" title="<?php echo e(__($item->name)); ?>">
                            <?php if(strlen(__($item->name)) >20): ?>
                            <?php echo e(substr( __($item->name), 0,20).'...'); ?>

                            <?php else: ?>
                            <?php echo e(__($item->name)); ?>

                            <?php endif; ?>
                        </h3>
                        <p class="pricing-plan-item__top-desc"><?php echo app('translator')->get('What You Are Looking For'); ?>!</p>
                    </div>
                    <div class="pricing-plan-item__price">
                        <h3 class="title"><?php echo e($general->cur_sym); ?> <?php echo e(showAmount($item->price)); ?></h3>
                    </div>
                    <div class="pricing-plan-item__list">
                        <ul>
                            <?php if(@$item->content): ?>
                            <?php $__currentLoopData = json_decode(@$item->content); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li> <i class="far fa-check-circle"></i> <?php echo e($value); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </ul>
                    </div>
                    <div class="pricing-plan-item__bottom">
                        <a class="btn btn--base" href="<?php echo e(route('user.brnad.package',$item->id)); ?>">
                            <?php echo app('translator')->get('Get Started'); ?> <i class="fas fa-arrow-right"></i>
                        </a>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </div>
    </div>
</section>
<?php /**PATH C:\xampp\htdocs\smm\application\resources\views/presets/default/sections/brand_package.blade.php ENDPATH**/ ?>