<?php $__env->startSection('panel'); ?>

<div class="row">
    <div class="col-lg-12">
        <div class="card b-radius--10 ">
            <div class="card-body p-0">
                <div class="table-responsive--sm table-responsive">
                    <table class="table table--light style--two">
                        <thead>
                            <tr>
                                <th><?php echo app('translator')->get('Category Name'); ?></th>
                                <th><?php echo app('translator')->get('Service Name'); ?></th>
                                <th><?php echo app('translator')->get('Provider'); ?></th>
                                <th><?php echo app('translator')->get('Price'); ?></th>
                                <th><?php echo app('translator')->get('Min'); ?></th>
                                <th><?php echo app('translator')->get('Max'); ?></th>
                                <th><?php echo app('translator')->get('Status'); ?></th>
                                <th><?php echo app('translator')->get('Action'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e(__(@$item->category->name)); ?></td>
                                <td><?php echo e(__($item->name)); ?></td>
                                <td>
                                    <?php if(@$item->provider->name): ?>
                                        <span class="badge badge--primary" title="Api Provider"><?php echo e(__(@$item->provider->name)); ?></span>
                                        <?php else: ?>
                                        <span class="badge badge--warning"><?php echo app('translator')->get('Manual'); ?></span>
                                    <?php endif; ?>
                            </td>
                                <td><?php echo e(showAmount($item->price)); ?></td>
                                <td><?php echo e(__($item->min)); ?></td>
                                <td><?php echo e(__($item->max)); ?></td>
                                <td>
                                    <?php
                                        echo $item->statusBadge($item->status);
                                    ?>
                                </td>


                                <td>
                                    <a href="<?php echo e(route('admin.services.edit',$item->id)); ?>" title="<?php echo app('translator')->get('Edit'); ?>"
                                     data-id="<?php echo e($item->id); ?>"
                                        class="btn btn-sm btn--primary ">
                                        <i class="las la-edit"></i>
                                    </a>
                                    <button title="<?php echo app('translator')->get('Remove'); ?>"
                                     data-id="<?php echo e($item->id); ?>"
                                        class="btn btn-sm btn--danger rejectBtn">
                                        <i class="las la-trash"></i>
                                    </button>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                            </tr>
                            <?php endif; ?>

                        </tbody>
                    </table><!-- table end -->
                </div>
            </div>
            <?php if($services->hasPages()): ?>
            <div class="card-footer py-4">
                <?php echo e(paginateLinks($services)); ?>

            </div>
            <?php endif; ?>
        </div><!-- card end -->
    </div>
</div>



<div id="rejectModal" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo app('translator')->get('Delete Service Confirmation'); ?></h5>
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <i class="las la-times"></i>
                </button>
            </div>
            <form action="<?php echo e(route('admin.services.delete')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="id">
                <div class="modal-body">
                    <p><?php echo app('translator')->get('Are you sure to'); ?> <span class="fw-bold"><?php echo app('translator')->get('delete'); ?></span> <span
                            class="fw-bold withdraw-amount text-success"></span> <?php echo app('translator')->get('this service'); ?> <span
                            class="fw-bold withdraw-user"></span>?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn--danger btn-global"><?php echo app('translator')->get('Delete'); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
<a href="<?php echo e(route('admin.services.create')); ?>" class="btn btn-sm btn--primary ">
    <?php echo app('translator')->get('Add Service'); ?></a>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
<script>
    "use strict";
    $('.rejectBtn').on('click', function () {
            var modal = $('#rejectModal');
            modal.find('input[name=id]').val($(this).data('id'));
            modal.modal('show');
        });
</script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\smm\application\resources\views/admin/services/index.blade.php ENDPATH**/ ?>