<?php $__env->startSection('panel'); ?>

<div class="row mb-none-30">
    <div class="col-lg-12 mb-30">
        <div class="card">
            <div class="card-body">
                <form action="<?php echo e(route('admin.services.store')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="api_provider_id">
                    <input type="hidden" name="api_service_id">
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="form-group">
                                <label for="name" class="font-weight-bold"><?php echo app('translator')->get('Service Name'); ?></label>
                                <select class="form-control" name="name" id="apiInfo" required="">
                                    <option selected><?php echo app('translator')->get('Select One'); ?></option>
                                    <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                     <option value="<?php echo e($item->name); ?>" data-service="<?php echo e(@$item->service); ?>"
                                        data-rate="<?php echo e(@$item->rate); ?>" data-min="<?php echo e(@$item->min); ?>" data-max="<?php echo e(@$item->max); ?>" data-category="<?php echo e(@$item->category); ?>" data-api_id="<?php echo e(@$item->api_id); ?>"><?php echo e(__($item->name)); ?></option>
                                     <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="form-group">
                                <label for="price" class="font-weight-bold"><?php echo app('translator')->get('Category Name'); ?></label>
                                <input type="text" name="category" id="category" value="<?php echo e(old('category')); ?>"
                                    class="form-control " placeholder="<?php echo app('translator')->get('Category Name'); ?>"
                                    required readonly>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="form-group">
                                <label for="price" class="font-weight-bold"><?php echo app('translator')->get('Price'); ?></label>
                                <input step="any" type="number" name="price" id="price" value="<?php echo e(old('price')); ?>"
                                    class="form-control " placeholder="<?php echo app('translator')->get('Price'); ?>"
                                    required>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="form-group">
                                <label for="min" class="font-weight-bold"><?php echo app('translator')->get('Min'); ?></label>
                                <input type="number" name="min" id="min" value="<?php echo e(old('min')); ?>"
                                    class="form-control " placeholder="<?php echo app('translator')->get('Min'); ?>"
                                    required readonly>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="form-group">
                                <label for="max" class="font-weight-bold"><?php echo app('translator')->get('Max'); ?></label>
                                <input type="number" name="max" id="max" value="<?php echo e(old('max')); ?>"
                                    class="form-control " placeholder="<?php echo app('translator')->get('Max'); ?>"
                                    required readonly>
                            </div>
                        </div>

                        <div class="col-lg-4">
                            <div class="form-group">
                                <label for="type" class="font-weight-bold"><?php echo app('translator')->get('Status'); ?></label>
                                <select name="status" id="status" class="form-control">
                                   <option value="1"><?php echo app('translator')->get('Active'); ?></option>
                                   <option value="0"><?php echo app('translator')->get('Deactive'); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div class="form-group">
                                <label for="details" class="font-weight-bold "><?php echo app('translator')->get('Details'); ?></label>
                                <textarea name="details" class="form-control" id="details" cols="30" rows="10" placeholder="<?php echo app('translator')->get('Details'); ?>"></textarea>
                            </div>
                        </div>

                        <div class="row text-end">
                            <div class="col-lg-12 ">
                                <div class="form-group float-end ">
                                    <button type="submit" class="btn btn--primary btn-block btn-lg"> <?php echo app('translator')->get('Create'); ?></button>
                                </div>
                            </div>
                        </div>
                 </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
<a href="<?php echo e(route('admin.services.index')); ?>" class="btn btn-sm btn--primary box--shadow1 text--small"><i
        class="las la-angle-double-left"></i><?php echo app('translator')->get('Go Back'); ?></a>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
<script>
    $(document).ready(function() {
        $('#apiInfo').on('change', function () {
            var selectedOption = $(this).find('option:selected');

            var rate = selectedOption.data('rate');
            $('input[name=price]').val(rate);

            var min = selectedOption.data('min');
            $('input[name=min]').val(min);

            var max = selectedOption.data('max');
            $('input[name=max]').val(max);

            var category = selectedOption.data('category');
            $('input[name=category]').val(category);

            var apiProviderId = selectedOption.data('api_id');
            $('input[name=api_provider_id]').val(apiProviderId);

            var apiServiceId = selectedOption.data('service');
            $('input[name=api_service_id]').val(apiServiceId);
        });
    });
</script>
<?php $__env->stopPush(); ?>




<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\smm\application\resources\views/admin/services/api_services.blade.php ENDPATH**/ ?>