<?php 
  // Page header
  echo show_page_header($controller_name, ['page-options' => 'search', 'search_params' => $params]);
?>

<div class="row">
  <?php if(!empty($items)){
  ?>
    <div class="col-md-12 col-xl-12">
      <div class="card">
        <?php $this->load->view('../partials_template/list_card_header.php'); ?>
        <div class="table-responsive">
          <table class="<?= get_table_class(); ?>">
            <?php echo render_table_thead($columns, true, true, false); ?>
            <tbody>
              <?php if (!empty($items)) {
                $i = $from;
                foreach ($items as $key => $item) {
                  $i++;
                  $item_checkbox = show_item_check_box('check_item', $item['ids']);
                  $full_name = show_high_light(esc($item['first_name']), $params['search'], 'first_name') . " " . show_high_light(esc($item['last_name']), $params['search'], 'last_name');
                  $email = show_high_light(esc($item['email']), $params['search'], 'email');
                  $ip_address = show_high_light(esc($item['ip']), $params['search'], 'ip');
                  $created = show_item_datetime($item['created'], 'long');
                  $item_activity = show_high_light(esc($item['event']), $params['search'], 'event');
              ?>
                <tr class="tr_<?php echo esc($item['ids']); ?>">
                  <th class="text-center w-1"><?php echo $item_checkbox; ?></th>
                  <td class="text-center text-muted w-5p"><?php echo $item['id']?></td>
                  <td class="text-center text-muted w-10p"><?php echo $item['country']?></td>
                  <td class="">
                    <div class="title"><h6><?php echo $full_name; ?></h6></div>
                    <div class="sub text-muted"><?php echo $email; ?></small></div>
                  </td>
                  <td class="text-muted w-15p"><?php echo $item_activity; ?></td>
                  <td class="w-20p"><?= esc($item['detail']); ?></td>
                  <td class="text-center text-muted w-15p"><?php echo $ip_address; ?></td>
                  <td class="text-center text-muted w-10p"><?php echo $created; ?></td>
                </tr>
              <?php }}?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
    <?php echo show_pagination($pagination); ?>
  <?php }else{
    echo show_empty_item();
  }?>
</div>
